within AixLib.Fluid.Actuators.Valves.ExpansionValves.UsersGuide;
class Composition "Composition of the expansion valves library"
  extends Modelica.Icons.Information;

  annotation (Documentation(info="<html>
<p>
The library of the expansion valves consists mainly of five packages.
</p>
<ol>
<li>
<a href=\"modelica://AixLib.Fluid.Actuators.Valves.ExpansionValves.ModularExpansionValves\">
ModularExpansionValves:</a> 
Contains models of modular expansion valves. These models are used, for
example, in modular heat pump models.</li>
<li>
<a href=\"modelica://AixLib.Fluid.Actuators.Valves.ExpansionValves.SimpleExpansionValves\">
SimpleExpansionValves:</a> 
Contains models of simple expansion valves. These models are used, for
example, in simple heat pump models.</li>
<li>
<a href=\"modelica://AixLib.Fluid.Actuators.Valves.ExpansionValves.Utilities\">
Utilities:</a> 
Contains utility models such as for flow coefficient calculation 
that are used throughout the library.</li>
<li>
<a href=\"modelica://AixLib.Fluid.Actuators.Valves.ExpansionValves.BaseClasses\">
BaseClasses:</a> 
Contains base models such as partial models for simple or modular
expansion valves that are used throughout the library.</li>
<li>
<a href=\"modelica://AixLib.Fluid.Actuators.Valves.ExpansionValves.Examples\">
Examples:</a> 
Contains example models to test the expansion valves
implemented in the library.</li>
</ol>
</html>", revisions="<html>
<ul>
  <li>
  October 19, 2017, by Mirko Engelpracht, Christian Vering:<br/>
  First implementation
  (see <a href=\"https://github.com/RWTH-EBC/AixLib/issues/457\">issue 457</a>).
  </li>
</ul>
</html>"));
end Composition;
